const fs = require("fs");
const path = require("path");
const express = require("express");
const cors = require("cors");
const http = require("https");
// const redis = require("redis");
const axios = require("axios");
const PORT = 3312;

class Server {
    constructor(port) {
        this.port = port;
        this.app = express();
        // this.redisClient = this.connectToRedis();
        this.httpServer = this.createServer();
        this.io = this.initSocket();
        this.setupMiddleware();
        this.setupSocketEvents();
    }

    //     connectToRedis() {
    //        const client = redis.createClient({
    //   url: 'redis://127.0.0.1:6380'  // replace with your Redis host and port
    // });

    // client.on("error", (err) => console.error("Redis Client Error", err));
    // client.connect();
    // return client;
    //     }

    createServer() {
        // const credentials = {
        //     key: fs.readFileSync(
        //         path.resolve(
        //             "/home/bandeddating/public_html/zeke-martin-backend/ssl/bandeddating.key"
        //         ),
        //         "utf8"
        //     ),
        //     cert: fs.readFileSync(
        //         path.resolve(
        //             "/home/bandeddating/public_html/zeke-martin-backend/ssl/bandeddating.crt"
        //         ),
        //         "utf8"
        //     ),
        //     ca: fs.readFileSync(
        //         path.resolve(
        //             "/home/bandeddating/public_html/zeke-martin-backend/ssl/bandeddating.ca"
        //         )
        //     ),
        // };
        // SSL Credentials
        const credentials = {
            key: fs.readFileSync(
                path.resolve(
                    "/home/customdevnewonli/public_html/ssl/customdevnewonli.key"
                ),
                "utf8"
            ),
            cert: fs.readFileSync(
                path.resolve(
                    "/home/customdevnewonli/public_html/ssl/customdevnewonli.crt"
                ),
                "utf8"
            ),
            ca: fs.readFileSync(
                path.resolve(
                    "/home/customdevnewonli/public_html/ssl/customdevnewonli.ca"
                )
            ),
        };
        this.app.use(cors());
        const server = http.createServer(credentials, this.app);

        // const server = http.createServer(this.app);
        server.listen(this.port, () => {
            console.log(
                `\u001b[34mServer started on port: ${this.port}\u001b[0m`
            );
        });
        return server;
    }

    initSocket() {
        const io = require("./socketConfig/socket").init(this.httpServer);
        return io;
    }

    setupMiddleware() {
        // Any additional middleware can be set up here
    }

    setupSocketEvents() {
        this.io.on("connection", (socket) => {
            console.log("User Joined");

            socket.on("sendMessage", (data) => this.handleSendMessage(data));
            // socket.on("updateLocation", (data) =>
            //     this.handleUpdateLocation(socket, data)
            // );
            // socket.on("getLocation", (userId) =>
            //     this.handleGetLocation(userId)
            // );
            socket.on("disconnect", () => this.handleDisconnect(socket));
        });
    }

    handleSendMessage(data) {
        console.log("Message Received");
        this.io.emit(data.chat_id, data);
    }

    // async handleUpdateLocation(socket, { userId, location }) {
    //     try {
    //         await this.redisClient.hSet(
    //             "userLocations",
    //             userId,
    //             JSON.stringify(location)
    //         );
    //         await this.redisClient.hSet("userSessions", socket.id, userId);
    //         this.io.emit(`userLocation${userId}`, { userId, location });
    //         console.log(`Updated location for ${userId}:`, location);
    //     } catch (error) {
    //         console.error("Error updating location:", error);
    //     }
    // }

    // async handleGetLocation(userId) {
    //     if (typeof userId !== "string" || !userId) {
    //         console.error("Invalid userId:", userId);
    //         return;
    //     }

    //     const location = await this.redisClient.hGet("userLocations", userId);
    //     console.log(`Get location for ${userId}:`, location);
    //     this.io.emit(`userLocation${userId}`, {
    //         userId,
    //         location: location ? JSON.parse(location) : null,
    //     });
    // }

    async handleDisconnect(socket) {
        try {
            // const userId = await this.redisClient.hGet(
            //     "userSessions",
            //     socket.id
            // );
            // const locationData = await this.redisClient.hGet(
            //     "userLocations",
            //     userId
            // );

            // let location;
            // if (locationData) {
            //     location = JSON.parse(locationData);
            // }
            // if (userId) {
            //     await this.redisClient.hDel("userSessions", socket.id);
            // }

            console.log("User session deleted for:", socket.id);
            // console.log("User info:", userId);

            // if (location) {
            //     console.log(
            //         "User location:",
            //         location.latitude,
            //         location.longitude
            //     );
            //     await axios.post(
            //         "https://bandeddating.com/zeke-martin-backend/api/location/update",
            //         {
            //             user_id: userId,
            //             longitude: location.longitude,
            //             latitude: location.latitude,
            //         }
            //     );
            //     console.log("Location sent successfully.");
            // }
        } catch (error) {
            console.error("Error during disconnect:", error);
        }
    }
}

// Initialize server
new Server(PORT);
