<?php

use App\Http\Controllers\Api\AppointmentController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ChatController;
use App\Http\Controllers\Api\ConsultantController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\PaymentLogController;
use App\Http\Controllers\Api\PlanController;
use App\Http\Controllers\Api\RatingController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Api\ServiceCategoryController;
use App\Http\Controllers\Api\ServiceController;
use App\Http\Controllers\Api\SubscriptionController;
use App\Http\Controllers\NotificationController;
use Illuminate\Support\Facades\Route;

Route::prefix('user')->group(function () {
    Route::post('/signup', [AuthController::class, 'signup']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('home', [HomeController::class, 'index']);
    // Consultants
    Route::get('consultants', [ConsultantController::class, 'consultants']);
    Route::get('consultant/{id}', [ConsultantController::class, 'consultant']);
    Route::get('consultant/service/{id}', [ConsultantController::class, 'ServiceConsultants']);
    Route::get('consultant/{id}/reviews', [ConsultantController::class, 'consultantReviews']);
    // Services Categories
    Route::get('serviceCategories', [ServiceCategoryController::class, 'index']);
    Route::get('serviceCategories/{serviceCategoy}/services', [ServiceController::class, 'categoryServices']);
    // TimeSlot
    Route::get('consultant/timeslots/{id}', [ConsultantController::class, 'getAvailableEvents']);
    // Services
    Route::get('services', [ServiceController::class, 'index']);
    Route::get('services/consultant/{id}', [ServiceCategoryController::class, 'consultantServiceCategories']);
    Route::get('service/{id}', [ServiceController::class, 'show']);
    // Appointments
    Route::post('appointment/create/web', [AppointmentController::class, 'createWeb']);
    // TimeSlot
    Route::post('consultant/timeslots', [ConsultantController::class, 'consultantTimeslot']);
    // Page
    Route::middleware(['auth:sanctum', 'user'])->group(function () {
        // Delete Account
        Route::post('delete', [AuthController::class, 'delete']);
        // Logout

        Route::post('/logout', [AuthController::class, 'logout']);
        // TimeSlot
        // Route::post('consultant/timeslots', [ConsultantController::class, 'consultantTimeslot']);
        // User Profile
        Route::get('profile', [AuthController::class, 'profile']);
        Route::get('profile/{user}', [AuthController::class, 'userProfile']);
        Route::post('profile/update', [AuthController::class, 'update']);
        Route::post('change-password', [AuthController::class, 'updatePassword']);

        // Appointments
        Route::get('appointments', [AppointmentController::class, 'index']);
        Route::get('appointments/{id}', [AppointmentController::class, 'view']);
        Route::post('appointment/create', [AppointmentController::class, 'create']);
        // Reports
        Route::post('report/create', [ReportController::class, 'store']);
        // Rating
        Route::post('rating/create', [RatingController::class, 'store']);
        // PaymentLosg
        Route::get('paymentlogs', [PaymentLogController::class, 'index']);

        // User Subscription
        Route::get('subscriptions', [SubscriptionController::class, 'userSubscription']);
        Route::post('subscribe', [SubscriptionController::class, 'store']);
        // //Plan
        Route::get('plans', [PlanController::class, 'listActive']);
        // Chat Routes
        Route::get('chat/getUnread-chats', [ChatController::class, 'get_unread_chats']);
        Route::get('chat/getChatList', [ChatController::class, 'get_chat_list']);
        Route::get('chat/getChat/{id}', [ChatController::class, 'get_chat']);
        Route::post('chat/sendMessage', [ChatController::class, 'send_message']);
        Route::post('chat/create', [ChatController::class, 'createChat']);
        Route::post('chat/createGroup', [ChatController::class, 'createGroup']);
        Route::get('chat/leaveGroup/{id}', [ChatController::class, 'leaveGroup']);
        // Notification
        Route::get('notification/unread/list', [NotificationController::class, 'unread']);
        Route::get('notification/all/list', [NotificationController::class, 'index']);
        Route::post('notification/all/read', [NotificationController::class, 'mark']);
        Route::post('notification/all/unread', [NotificationController::class, 'unread']);
        Route::post('notification/read', [NotificationController::class, 'individual']);
        Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
        Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
    });

});
