<?php

use App\Http\Controllers\Admin\ChartController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ChatController;
use App\Http\Controllers\Consultant\AppointmentController;
use App\Http\Controllers\Consultant\AuthController as ConsultantAuthController;
use App\Http\Controllers\Consultant\CategoryController;
use App\Http\Controllers\Consultant\ConsultantController;
use App\Http\Controllers\Consultant\HomeController;
use App\Http\Controllers\Consultant\ReportController;
use App\Http\Controllers\Consultant\ServiceController;
use App\Http\Controllers\Consultant\SubCategoryController;
use App\Http\Controllers\NotificationController;
use Illuminate\Support\Facades\Route;

Route::prefix('consultant')->group(function () {
    // Route::post('/signup', [ConsultantController::class, 'signup']);
    Route::post('/login', action: [ConsultantAuthController::class, 'login']);

    Route::middleware(['auth:sanctum', 'consultant'])->group(function () {
        // Logout
        Route::post('/logout', [ConsultantAuthController::class, 'logout']);
        // Dashboard
        Route::get('dashboard', [HomeController::class, 'dashboardStats']);
        // Reports
        Route::post('report/create', [ReportController::class, 'store']);
        // User Profile
        Route::get('profile', [ConsultantAuthController::class, 'profile']);
        Route::get('profile/{user}', [AuthController::class, 'userProfile']);
        Route::post('profile/update', [ConsultantAuthController::class, 'update']);
        Route::get('image/delete/{image}', [ConsultantAuthController::class, 'deleteImage']);
        Route::post('change-password', [AuthController::class, 'updatePassword']);
        // Page
        Route::get('page/{page}', [PageController::class, 'showBySlug']);
        // Consultants
        Route::get('reviews', [ConsultantController::class, 'consultantReviews']);
        Route::get('timeslots', [ConsultantController::class, 'consultantTimeslot']);
        Route::post('timeslots', [ConsultantController::class, 'updateTimeslots']);
        // Category
        Route::get('categories', [CategoryController::class, 'list']);
        // Sub Category
        Route::get('subCategories/category/{id}', [SubCategoryController::class, 'list']);
        // Services
        Route::get('services', [ServiceController::class, 'consultantServices']);
        Route::get('services/{id}', [ServiceController::class, 'show']);
        // Appointments
        Route::get('appointments', [AppointmentController::class, 'index']);
        Route::post('appointments/{id}', [AppointmentController::class, 'update']);
        Route::get('appointments/{id}', [AppointmentController::class, 'view']);
        Route::get('chartss/dropdown', [ChartController::class, 'dropdownChart']);
        Route::get('chart/{chart}', [ChartController::class, 'show']);

        // Chat Routes
        Route::get('chat/getUnread-chats', [ChatController::class, 'get_unread_chats']);
        Route::get('chat/getChatList', [ChatController::class, 'get_chat_list']);
        Route::get('chat/getChat/{id}', [ChatController::class, 'get_chat']);
        Route::post('chat/sendMessage', [ChatController::class, 'send_message']);
        Route::post('chat/create', [ChatController::class, 'createChat']);
        Route::post('chat/createGroup', [ChatController::class, 'createGroup']);
        Route::get('chat/leaveGroup/{id}', [ChatController::class, 'leaveGroup']);
        // Notification
        Route::get('notification/unread/list', [NotificationController::class, 'unread']);
        Route::get('notification/all/list', [NotificationController::class, 'index']);
        Route::post('notification/all/read', [NotificationController::class, 'mark']);
        Route::post('notification/read', [NotificationController::class, 'individual']);
        Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
        Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
    });
});
