<?php

use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\FeedbackController as ApiFeedbackController;
use App\Http\Controllers\Api\StripeController;
use App\Http\Controllers\Api\SubscriptionController;
use Illuminate\Support\Facades\Route;

// Admin Routes
require __DIR__.'/admin.php';
// User Routes
require __DIR__.'/user.php';
// Consultant Routes
require __DIR__.'/user-consultant.php';
// General Routes
Route::post('/reset/password', [AuthController::class, 'reset']);
Route::post('/verify/code', [AuthController::class, 'verifyCode']);
Route::post('/set/password', [AuthController::class, 'setPassword']);
// Payment Routes
Route::get('/checkout/success', [StripeController::class, 'success'])->name('checkout.success');
Route::get('/checkout/cancel', [StripeController::class, 'cancel'])->name('checkout.cancel');
Route::post('/check/push-notification', [StripeController::class, 'checkPushNotification']);
// Subscription Routes
Route::get('subscription/success', [SubscriptionController::class, 'success'])->name('subscription.success');
// Route::get('/subscription/success', [SubscriptionController::class, 'success'])->name('subscription.success');
Route::get('/subscription/cancel', [SubscriptionController::class, 'cancel'])->name('subscription.cancel');
Route::post('contact-us', [ApiFeedbackController::class, 'store']);
Route::get('page/{page}', [PageController::class, 'showBySlug']);
