<?php

use App\Http\Controllers\Admin\AppointmentController;
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ChartController;
use App\Http\Controllers\Admin\ConsultantController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\Admin\ImageController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PaymentLogController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\PushNotificationController;
use App\Http\Controllers\Admin\ReportController as AdminReportController;
use App\Http\Controllers\Admin\ServiceCategoryController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SubCategoryController;
use App\Http\Controllers\Admin\TimeSlotController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\NotificationController;
use Illuminate\Support\Facades\Route;

Route::prefix('admin')->group(function () {
    Route::middleware(['admin'])->group(function () {
        Route::post('/login', [AdminAuthController::class, 'login']);
    });
    Route::middleware(['auth:sanctum', 'admin'])->group(function () {
        // Logout
        Route::post('/logout', [AuthController::class, 'logout']);
        // Admin Profile
        Route::get('profile', [AdminAuthController::class, 'profile']);
        Route::post('profile/update', [AdminAuthController::class, 'update']);
        Route::post('change-password', [AdminAuthController::class, 'updatePassword']);
        // Dashboard
        Route::get('dashboard/stats', [AdminAuthController::class, 'dashboardStats']);
        Route::get('dashboard/chartEarningStats', [AdminAuthController::class, 'chartEarningStats']);
        Route::get('dashboard/chartUsersStats', [AdminAuthController::class, 'chartUsersStats']);
        Route::get('dashboard/chartBookingStats', [AdminAuthController::class, 'chartBookingStats']);
        Route::get('dashboard/userStats', [AdminAuthController::class, 'userStats']);
        Route::get('chart/data', [AdminAuthController::class, 'chartData']);
        Route::get('chart/filter', [AdminAuthController::class, 'filterChartData']);
        // User
        Route::get('users', [UserController::class, 'index']);
        Route::post('user/{user}/status', [UserController::class, 'status']);
        Route::get('user/{user}', [UserController::class, 'show']);
        Route::delete('user/{user}', [UserController::class, 'delete']);
        // Consultant
        Route::get('consultants', [ConsultantController::class, 'index']);
        Route::get('consultants/active', [ConsultantController::class, 'active']);
        Route::get('consultants/activeWihPagination', [ConsultantController::class, 'activeWithPagination']);
        Route::post('consultant/create', [ConsultantController::class, 'create']);
        Route::post('consultant/{user}/status', [ConsultantController::class, 'status']);
        Route::get('consultant/{user}', [ConsultantController::class, 'show']);
        Route::get('consultant/{id}/ratings', [ConsultantController::class, 'ratings']);
        Route::get('consultant/{user}/services', [ServiceController::class, 'consultantServicesWithPagination']);
        Route::delete('consultant/{user}', [ConsultantController::class, 'delete']);

        // Service Category
        Route::get('serviceCategories', [ServiceCategoryController::class, 'index']);
        Route::get('serviceCategories/active', [ServiceCategoryController::class, 'active']);
        Route::post('serviceCategory/create', [ServiceCategoryController::class, 'create']);
        Route::post('serviceCategory/{id}/status', [ServiceCategoryController::class, 'status']);
        Route::post('serviceCategory/{id}/update', [ServiceCategoryController::class, 'update']);
        Route::get('serviceCategory/{id}', [ServiceCategoryController::class, 'show']);
        Route::delete('serviceCategories/{id}', [ServiceCategoryController::class, 'delete']);
        // Service
        Route::get('services', [ServiceController::class, 'index']);
        Route::post('services/reorder', [ServiceController::class, 'reorder']);
        Route::post('service/create', [ServiceController::class, 'create']);
        Route::post('service/{id}/status', [ServiceController::class, 'status']);
        Route::post('service/{id}/update', [ServiceController::class, 'update']);
        Route::get('service/{id}', [ServiceController::class, 'show']);
        Route::delete('service/{id}', [ServiceController::class, 'delete']);
        // TimeSlot (recurring weekly pattern)
        Route::post('timeslot/create', [TimeSlotController::class, 'create']);
        Route::get('timeslots/{id}', [TimeSlotController::class, 'consultantTimeslot']);

        // Reports
        Route::get('report/reports', [AdminReportController::class, 'index']);
        Route::get('report/{report}', [AdminReportController::class, 'show']);
        Route::post('report/{report}/status', [AdminReportController::class, 'status']);
        // Payment Log Module
        Route::get('payment/logs', [PaymentLogController::class, 'index']);
        Route::get('subscriptions/logs', [PaymentLogController::class, 'subscriptions']);
        // Push Notification
        Route::post('send/push-notification', [PushNotificationController::class, 'send']);
        // Images
        Route::delete('image/{id}/delete', [ImageController::class, 'delete']);
        // Plan
        Route::get('plans', [PlanController::class, 'list']);
        Route::get('plans/{plan}', [PlanController::class, 'view']);
        Route::post('plans', [PlanController::class, 'create']);
        Route::post('plans/{id}', [PlanController::class, 'update']);
        Route::delete('plans/{id}', [PlanController::class, 'delete']);
        Route::get('plans/{id}/status', [PlanController::class, 'status']);
        // Category
        Route::get('categories', [CategoryController::class, 'list']);
        Route::get('categories/without/Pagination', [CategoryController::class, 'activelistWithoutPagination']);
        Route::get('categories/{category}', [CategoryController::class, 'view']);
        Route::post('categories', [CategoryController::class, 'create']);
        Route::post('categories/{id}', [CategoryController::class, 'update']);
        Route::delete('categories/{id}', [CategoryController::class, 'delete']);
        Route::get('categories/{id}/status', [CategoryController::class, 'status']);
        // Sub Category
        Route::get('subCategories', [SubCategoryController::class, 'list']);
        Route::get('subCategories/{subCategory}', [SubCategoryController::class, 'view']);
        Route::post('subCategories', [SubCategoryController::class, 'create']);
        Route::post('subCategories/{id}', [SubCategoryController::class, 'update']);
        Route::delete('subCategories/{id}', [SubCategoryController::class, 'delete']);
        Route::get('subCategories/{id}/consultants', [SubCategoryController::class, 'consultants']);
        Route::get('subCategories/{id}/consultants/{user_id}', [SubCategoryController::class, 'details']);
        Route::get('subCategories/{id}/status', [SubCategoryController::class, 'status']);
        // Feedbacks
        Route::get('feedbacks', [FeedbackController::class, 'index']);
        Route::get('feedbacks/{feedback}', [FeedbackController::class, 'show']);
        // Appointment
        Route::get('appointments', [AppointmentController::class, 'index']);
        Route::get('appointments/{appointment}', [AppointmentController::class, 'show']);
        Route::get('appointments/{id}/user', [AppointmentController::class, 'userAppointment']);
        Route::get('appointments/{id}/consultant', [AppointmentController::class, 'consultantAppointment']);

        // Pages
        Route::get('pages', [PageController::class, 'index']);
        Route::post('page', [PageController::class, 'create']);
        Route::get('page/{page}', [PageController::class, 'show']);
        Route::post('page/{page}/update', [PageController::class, 'update']);

        // Chart Managment
        Route::get('charts', [ChartController::class, 'index']);
        Route::post('chart', [ChartController::class, 'create']);
        Route::get('chart/{chart}', [ChartController::class, 'show']);
        Route::post('chart/{chart}/update', [ChartController::class, 'update']);
        Route::post('chart/submit', [ChartController::class, 'submitChart']);
        Route::get('chartss/dropdown', [ChartController::class, 'dropdownChart']);

        // Notification
        Route::get('notification/unread/list', [NotificationController::class, 'unread']);
        Route::get('notification/read/list', [NotificationController::class, 'read']);
        Route::get('notification/all/list', [NotificationController::class, 'index']);
        Route::get('notification/all/readNotifications', [NotificationController::class, 'read']);
        Route::post('notification/all/read', [NotificationController::class, 'mark']);
        Route::post('notification/read', [NotificationController::class, 'individual']);
        Route::post('notification/unread', [NotificationController::class, 'markAsUnread']);
        Route::get('unread/notification/count', [NotificationController::class, 'unreadNotificationCount']);
        Route::get('unread/message/count', [NotificationController::class, 'unreadMessageCount']);
    });
});
