<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('weekly_time_slots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('consultant_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->string('day_of_week'); // e.g. Monday, Tuesday
            $table->time('time'); // start time of the slot
            $table->string('status')->default('available'); // available | cancelled | booked
            $table->timestamps();

            $table->unique(['consultant_id', 'day_of_week', 'time'], 'weekly_slots_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('weekly_time_slots');
    }
};


