<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('consultant_inventories', function (Blueprint $table) {
            $table->id();
            $table->integer('quantity')->default(0);
            $table->foreignId('category_id')->references('id')->on('categories')->cascadeOnDelete()->default(null);
            $table->foreignId('sub_category_id')->references('id')->on('sub_categories')->cascadeOnDelete()->default(null);
            $table->foreignId('user_id')->references('id')->on('users')->cascadeOnDelete()->default(null);
            $table->foreignId('appointment_id')->references('id')->on('appointments')->cascadeOnDelete()->default(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('consultant_inventories');
    }
};
