<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->text('personal_details')->nullable()->after('status');  // Changed to text for longer details
            $table->string('licence_no')->nullable()->after('personal_details');  // Kept as string (assuming alphanumeric)
            $table->date('license_expiration')->nullable()->after('licence_no');  // Changed to date type
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['personal_details', 'licence_no', 'license_expiration']);
        });
    }
};
