<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('plan_id')->references('id')->on('plans')->cascadeOnDelete()->default(null);
            $table->string('stripe_customer_id');
            $table->string('stripe_subscription_id');
            $table->string('stripe_price_id');
            $table->boolean('auto_renew')->default(true);  // Auto-renew status
            $table->timestamp('ends_at')->nullable();     // When subscription ends

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_subscriptions');
    }
};
