<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('stripe_product_id'); // Stripe Product ID
            $table->string('stripe_price_id');   // Stripe Price ID
            $table->string('name');               // Plan name
            $table->double('amount');            // Amount in cents
            $table->string('currency');           // Currency (e.g. USD)
            $table->string('interval'); // monthly, yearly, etc.
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
