<?php

use App\Models\Appointment;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('country_code')->nullable();
            $table->string('dial_code')->nullable();
            $table->date('booking_date');
            $table->enum('status', [Appointment::UPCOMING, Appointment::INPROGRESS, Appointment::PAST])->default(Appointment::UPCOMING);
            $table->foreignId('service_id')->references('id')->on('services')->cascadeOnDelete()->default(null);
            $table->foreignId('time_slot_id')->references('id')->on('time_slots')->cascadeOnDelete()->default(null);
            $table->foreignId('consultant_id')->references('id')->on('users')->cascadeOnDelete()->default(null);
            $table->foreignId('user_id')->references('id')->on('users')->cascadeOnDelete()->default(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
