<?php

namespace App\Services;

use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;

/**
 * Class JsonResponseService
 */
class UserService extends BaseService
{
    public function index($type = 'user')
    {
        $users = User::where('type', '=', $type)
            ->when(request()->filled('status') && request('status') != 2, function ($q) {
                $q->whereStatus(request('status'));
            })
            ->when(request()->filled('search'), function ($q) {

                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%'.request('search').'%')
                        ->orWhere('last_name', 'like', '%'.request('search').'%')
                        ->orWhere('email', 'like', '%'.request('search').'%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%'.request('search').'%');

                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'));

                if (request()->filled('toDate')) {
                    $q->whereDate('created_at', '<=', request('toDate'));
                }
            })
            ->when(request()->filled('sort'), function ($q) {

                $q->where('status', '=', request('sort'));

            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);

        return $users;
    }

    public function show($id)
    {
        $user = User::find($id);

        return $user;
    }

    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();

        return $user;
    }

    /**
     * Soft delete a user by id.
     */
    public function destroy($id): bool
    {
        $user = User::findOrFail($id);
        $user->delete(); // uses SoftDeletes on User model

        return true;
    }
}
