<?php

namespace App\Services;

use App\Models\ServiceCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class ServiceCategoryService extends BaseService
{
    public function index($type = 'consultant')
    {
        $ServiceCategories = ServiceCategory::when(request()->filled('status') && request('status') != 2, function ($q) {
            $q->whereStatus(request('status'));
        })
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('title', 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))->whereDate('created_at', '<=', request('to'));
            })
            ->when(request()->filled('sort'), function ($q) {

                $q->where('status', '=', request('sort'));

            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $ServiceCategories;
    }

    public function active()
    {
        $ServiceCategories = ServiceCategory::where('status', 1)
            ->with('services', 'services.consultants')
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('title', 'like', '%' . request("search") . '%');
                });
            })
            ->orderBy('id', 'desc')
            ->get();
        return $ServiceCategories;
    }

    public function consultantServiceCategories($consultant_id)
    {
        $ServiceCategories = ServiceCategory::where('status', 1)
            ->with('services', 'services.consultants')
            ->whereHas("services.consultants", function ($q) use ($consultant_id) {
                $q->where('user_id', $consultant_id);
            })
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('title', 'like', '%' . request("search") . '%');
                });
            })
            ->orderBy('id', 'desc')
            ->get();
        return $ServiceCategories;
    }

    public function show($id)
    {
        $serviceCategory = ServiceCategory::find($id);
        return $serviceCategory;
    }

    public function create($request)
    {
        $serviceCategory = new ServiceCategory();
        $serviceCategory->title = $request->title;
        $serviceCategory->status = $request->status;
        $serviceCategory->save();
        if ($request->hasFile('file')) {
            storeImage($request, 'file', ServiceCategory::IMAGES_DIRECTORY, $serviceCategory);
        }
        return $serviceCategory;
    }

    public function update($request, $id)
    {
        $serviceCategory = ServiceCategory::find($id);
        $serviceCategory->title = $request->title;
        $serviceCategory->status = $request->status;
        $serviceCategory->save();
        if ($request->hasFile('file')) {
            storeImage($request, 'file', ServiceCategory::IMAGES_DIRECTORY, $serviceCategory);
        }
        return $serviceCategory;
    }

    public function accountStatus($userId)
    {
        $serviceCategory = ServiceCategory::find($userId);
        $serviceCategory->status = ($serviceCategory->status == 1) ? 0 : 1;
        $serviceCategory->save();
        return $serviceCategory;
    }

    public function delete($id)
    {
        $serviceCategory = ServiceCategory::findOrFail($id);
        $serviceCategory->delete();

        return $serviceCategory;
    }
}
