<?php

namespace App\Services;

use App\Models\Appointment;
use App\Models\Chat;
use App\Models\Report;
use App\Models\StoreCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Http\Resources\Json\JsonResource;
use Mockery\Exception;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class ReportService extends BaseService
{
    public function index()
    {
        $reports = Report::with(['user', 'reportable'])
            ->where(function ($query) {
                $query->when(request()->filled('search'), function ($q) {
                    $searchTerm = request('search');
                    $q->whereHas('user', function ($sq) use ($searchTerm) {
                        $sq->where('first_name', 'like', '%' . $searchTerm . '%')
                            ->orWhere('last_name', 'like', '%' . $searchTerm . '%')
                            ->orWhere('email', 'like', '%' . $searchTerm . '%');
                    });
                });
            })
            ->when(request()->filled('status') && request('status') !== 0, function ($q) {
                $q->where('status', '=', request('status'));
            })
            ->when(request()->filled('type') && request('type') !== 0, function ($q) {
                $type = "App\\Models\\" . request('type');
                $q->where('reportable_type', '=', $type);
            })
            ->when(request()->filled('fromDate') && request()->filled('toDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);

        return $reports;
    }

    public function show($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }

    public function store($request)
    {
        // $report = Report::where('reportable_id', $request->reportable_id)->where('user_id', auth()->user()->id)->first();
        $report = Report::where('reportable_id', $request->reportable_id)->where('user_id', auth()->user()->id)->first();
        if (!$report) {
            $report = new Report();
        }
        $report->reportable_type = Appointment::class;
        $report->reportable_id = $request->reportable_id;
        $report->reason = $request->reason;
        $report->user_id = auth()->user()->id;
        $report->status = Report::PENDING;
        $report->save();
        $title = auth()->user()->first_name . " " . auth()->user()->last_name . " reported an order !";
        $body = auth()->user()->id;
        $data = [
            "user_id" => auth()->user()->id,
            "title" => auth()->user()->first_name . " " . auth()->user()->last_name . " reported an order !",
            "body" => auth()->user()->id,
        ];
        sendNotificationToAdmin($title, $body, $data, auth()->user()->id);
        return $report;
    }

    public function reportChat($request)
    {
        // $report = Report::where('reportable_id', $request->reportable_id)->where('user_id', auth()->user()->id)->first();
        $report = Report::where('reportable_id', $request->reportable_id)->where('user_id', auth()->user()->id)->first();
        if (!$report) {
            $report = new Report();
        }
        $report->reportable_type = Chat::class;
        $report->reportable_id = $request->reportable_id;
        $report->reason = $request->reason;
        $report->user_id = auth()->user()->id;
        $report->status = Report::PENDING;
        $report->save();
        $title = auth()->user()->first_name . " " . auth()->user()->last_name . " reported an order !";
        $body = auth()->user()->id;
        $data = [
            "user_id" => auth()->user()->id,
            "title" => auth()->user()->first_name . " " . auth()->user()->last_name . " reported an order !",
            "body" => auth()->user()->id,
        ];
        sendNotificationToAdmin($title, $body, $data, auth()->user()->id);
        return $report;
    }

    public function changeStatus($report_id)
    {
        $report = Report::find($report_id);
        $report->status = ($report->status == Report::PENDING) ? Report::RESOLVED : Report::PENDING;
        $report->save();
        $user = User::find($report->user_id);

        $title = "Your order report has been resolved!";
        $body = $user->id;
        $data = [
            "user" => $user,
            "title" => $title,
            "body" => $user->id,
        ];
        // sendNotificationToUser($title, $body, $data, $user);
        return $report;
    }
}
