<?php

namespace App\Services;

use App\Models\Rating;
use App\Services\Common\BaseService;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class RatingService extends BaseService
{
    public function store($request)
    {
        $rating = new Rating();
        $rating->rating = $request->rating;
        $rating->review = $request->review;
        $rating->consultant_id = $request->consultant_id;
        $rating->user_id = auth()->user()->id;
        $rating->save();
        return $rating;
    }
    public function update($request, $id)
    {
        $rating = Rating::find($id);
        $rating->rating = $request->rating;
        $rating->review = $request->review;
        $rating->save();
        return $rating;
    }
    public function checkRating($consultant_id, $user_id)
    {
        $rating = Rating::where('consultant_id', $consultant_id)->where('user_id', $user_id)->first();
        return $rating;
    }

}
