<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\DeliveryCharges;
use App\Models\Order;
use App\Models\OrderAddress;
use App\Models\OrderDetail;
use App\Models\PaymentLog;
use App\Models\UserSubscription;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class PaymentLogService extends BaseService
{

    public function index()
    {
        $paymentLogs = PaymentLog::where('paymentable_type', 'App\Models\Appointment')->with(['user']) // Eager load the order and address relationships
            ->when(request()->filled('search'), function ($q) {
                $search = request('search');

                $q->where(function ($q) use ($search) {
                    $q->where('id', 'like', '%' . $search . '%')
                        ->orWhereHas('user', function ($query) use ($search) {
                            $query->where('first_name', 'like', '%' . $search . '%')
                                ->orWhere('last_name', 'like', '%' . $search . '%')
                                ->orWhere('email', 'like', '%' . $search . '%')
                                ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                        });
                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $paymentLogs;
    }

    public function userPaymentLogs($user_id)
    {
        $paymentLogs = PaymentLog::where('paymentable_type', 'App\Models\Appointment')->where('user_id', $user_id)->with(['user']) // Eager load the order and address relationships
            ->when(request()->filled('search'), function ($q) {
                $search = request('search');

                $q->where(function ($q) use ($search) {
                    $q->where('id', 'like', '%' . $search . '%')
                        ->orWhereHas('user', function ($query) use ($search) {
                            $query->where('first_name', 'like', '%' . $search . '%')
                                ->orWhere('last_name', 'like', '%' . $search . '%')
                                ->orWhere('email', 'like', '%' . $search . '%')
                                ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                        });
                });
            })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $paymentLogs;
    }

    public function subscriptions()
    {
        $paymentLogs = UserSubscription::when(request()->filled('search'), function ($q) {
            $search = request('search');
            $q->where(function ($q) use ($search) {
                $q->where('id', 'like', '%' . $search . '%')
                    ->orWhereHas('user', function ($query) use ($search) {
                        $query->where('first_name', 'like', '%' . $search . '%')
                            ->orWhere('last_name', 'like', '%' . $search . '%')
                            ->orWhere('email', 'like', '%' . $search . '%')
                            ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . $search . '%');
                    });
            });
        })
            ->when(request()->filled('fromDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $paymentLogs;
    }

}
