<?php

namespace App\Services;

use App\Http\Resources\DefaultResource;
use App\Http\Resources\NotificationResource;
use App\Models\User;
use App\Services\Common\BaseService;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class NotificationService extends BaseService
{
    public function index($type = 'user')
    {
        $notification = auth()->user()->notifications();
        if (request()->filled('status') && request('status') == 'unread') {
            $notification = auth()->user()->unreadNotifications();
        }
        if (request()->filled('status') && request('status') == 'read') {
            $notification = auth()->user()->readNotifications();
        }
        return NotificationResource::collection(
            $notification->paginate($this->pagination)
        );
    }

    public function mark()
    {
        auth()->user()->unreadNotifications()->get()->map(function ($n) {
            $n->markAsRead();
        });
        return new DefaultResource(['message' => 'Marked unread all notification!']);


        // return auth()->user()->unreadNotifications();

        // return response()->json(["message" => "Marked unread all notification"], 200);
    }

    public function unread()
    {
        auth()->user()->readNotifications()->get()->map(function ($n) {
            $n->markAsUnread();
        });
        return new DefaultResource(['message' => 'Marked read all notification!']);
        // return NotificationResource::collection(
        //     auth()->user()->unreadNotifications()->paginate()
        // );
    }

    public function read()
    {
        return NotificationResource::collection(
            auth()->user()->readNotifications()->paginate()
        );
    }

    public function markAsUnread($request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        return $notification->markAsUnread();
    }

    public function individual($request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        $notification->markAsRead();
        return NotificationResource::collection(
            $notification
        );
    }

    public function unreadNotificationCount()
    {

        return response()->json(["count" => auth()->user()->unreadNotifications()->count()], 200);
    }

    public function unreadMessageCount()
    {
        return response()->json(["count" => auth()->user()->unreadNotifications()->whereRaw('JSON_CONTAINS(`data`, \'{"data": {"type": "message"}}\')')->count()], 200);
    }
}
