<?php

namespace App\Services;

use App\Http\Resources\Service\ServiceResource;
use App\Http\Resources\ServiceCategory\ServiceCategoryWithServiceResource;
use App\Http\Resources\User\ConsultantWithRatingResource;
use App\Http\Resources\User\UserWithRatingListingResource;
use App\Models\Rating;
use App\Models\Service;
use App\Models\ServiceCategory;
use App\Models\User;
use App\Services\Common\BaseService;
use DB;


/**
 * Class JsonResponseService
 * @package App\Services
 */
class HomeService extends BaseService
{
    public function userHome($request)
    {
        $topConsultants = User::where('type', 'consultant')
            // ->withCount('ratings as total_reviews') // Count the number of ratings for each consultant
            // ->withAvg('ratings as average_rating', 'rating') // Calculate the average rating
            ->orderByDesc('id') // Order by the average rating in descending order
            ->where('status', 1)
            ->limit(4)
            ->get();

        $topServices = Service::with('serviceCategory')->
            where('status', 1)->
            limit(4)
            ->get();

        // $serviceCategories = ServiceCategory::
        //     where('status', 1)->
        //     with('limitedServices')
        //     ->get();
        $serviceCategories = ServiceCategory::where('status', 1)->get();

        $serviceCategories->each(function ($category) {
            $category->setRelation(
                'services',
                $category->services()->where('status', 1)->limit(4)->get()
            );
        });
        $data = [
            'consultants' => ConsultantWithRatingResource::collection($topConsultants),
            'services' => ServiceResource::collection($topServices),
            'service_categories' => ServiceCategoryWithServiceResource::collection($serviceCategories),
        ];
        return $data;
    }
    public function checkRating($product_id, $user_id)
    {
        $rating = Rating::where('product_id', $product_id)->where('user_id', $user_id)->first();
        return $rating;
    }

}
