<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Kreait\Firebase\Messaging\MulticastMessage;
class FirebaseService
{
    protected $messaging;

    public function __construct()
    {
        // $filePath = base_path('config/firebase_credentials.json');
        // $credentials = file_get_contents($filePath);
        // $credentialsArray = json_decode($credentials, true);
        $factory = (new Factory)->withServiceAccount(config('firebase.credentials'));
        $this->messaging = $factory->createMessaging();
    }

    public function sendNotification($token, $title, $body, $data = [])
    {
        $notification = Notification::create($title, $body);

        $message = CloudMessage::withTarget('token', $token)
            ->withNotification($notification)
            ->withData($data);

        return $this->messaging->send($message);
    }

    // public function sendNotificationToMultiple(array $tokens, string $title, string $body, array $data = [])
    // {
    //     // Create the notification instance
    //     $notification = Notification::create($title, $body);

    //     // Create a MulticastMessage for multiple recipients
    //     $message = MulticastMessage::withNotification($notification)
    //         ->withData($data)
    //         ->withTargets($tokens); // Set the targets to your array of tokens

    //     // Send the multicast message
    //     try {
    //         $response = $this->messaging->sendMulticast($message);
    //         // Log the results
    //         if ($response->successCount() > 0) {
    //             \Log::info("Notifications sent successfully to {$response->successCount()} tokens.");
    //         }
    //         if ($response->failureCount() > 0) {
    //             \Log::warning("Failed to send notifications to {$response->failureCount()} tokens.");
    //         }
    //     } catch (\Exception $e) {
    //         // Handle exceptions (e.g., log errors)
    //         \Log::error("Failed to send multicast notification: " . $e->getMessage());
    //     }
    // }
}
