<?php

namespace App\Services;

use App\Models\Rating;
use App\Models\Service;
use App\Models\User;
use App\Services\Common\BaseService;
use Illuminate\Support\Facades\DB;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class ConsultantService extends BaseService
{
    public function index($type = 'consultant')
    {
        $users = User::where('type', '=', 'consultant')
            ->when(request()->filled('status') && request('status') != 2, function ($q) {
                $q->whereStatus(request('status'));
            })
            ->when(request()->filled('search'), function ($q) {

                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%' . request("search") . '%')
                        ->orWhere('last_name', 'like', '%' . request("search") . '%')
                        ->orWhere('email', 'like', '%' . request("search") . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . request("search") . '%');

                });
            })
            ->when(request()->filled('fromDate') && request()->filled('toDate'), function ($q) {
                $q->whereDate('created_at', '>=', request('fromDate'))
                    ->whereDate('created_at', '<=', request('toDate'));
            })
            ->when(request()->filled('sort'), function ($q) {

                $q->where('status', '=', request('sort'));

            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $users;
    }

    public function activeWithPagination($type = 'consultant')
    {
        $users = User::where('type', '=', $type)
            ->where('status', 1)
            ->when(request()->filled('search'), function ($q) {

                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%' . request("search") . '%')
                        ->orWhere('last_name', 'like', '%' . request("search") . '%')
                        ->orWhere('email', 'like', '%' . request("search") . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . request("search") . '%');

                });
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $users;
    }

    public function active($type = 'consultant')
    {
        $users = User::where('type', '=', $type)
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->get();
        return $users;
    }

    public function activeConsultants($type = 'consultant')
    {
        $users = User::where('type', '=', $type)
            ->with('ratings')
            ->where('status', 1)
            ->withCount('ratings as total_reviews') // Count the number of ratings for each consultant
            ->withAvg('ratings as average_rating', 'rating') // Calculate the average rating
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%' . request("search") . '%')
                        ->orWhere('last_name', 'like', '%' . request("search") . '%')
                        ->orWhere('email', 'like', '%' . request("search") . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . request("search") . '%');
                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))->whereDate('created_at', '<=', request('to'));
            })
            ->orderByDesc('average_rating')
            ->paginate($this->pagination);
        return $users;
    }

    public function serviceConsultatnts($serviceId)
    {
        $service = Service::findOrFail($serviceId);
        $consultants = $service->consultants()
            ->where('status', 1)
            ->withCount('ratings as total_reviews') // Count the number of ratings for each consultant
            ->withAvg('ratings as average_rating', 'rating')
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('first_name', 'like', '%' . request("search") . '%')
                        ->orWhere('last_name', 'like', '%' . request("search") . '%')
                        ->orWhere('email', 'like', '%' . request("search") . '%')
                        ->orWhere(DB::raw("CONCAT(first_name, ' ', last_name)"), 'like', '%' . request("search") . '%');

                });
            })
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $consultants;
    }

    public function consultant($id)
    {
        $user = User::where('id', $id)->first();
        return $user;
    }

    public function show($id)
    {
        $user = User::find($id);
        return $user;
    }
    public function showWithRatings($id)
    {
        $user = User::where('id', $id)->with('ratings')->first();
        return $user;
    }
    public function consultantReviews($id)
    {
        $user = User::findOrFail($id);
        $ratings = $user->ratings()
            ->orderBy('id', 'desc')
            ->get();
        $user->setRelation('ratings', $ratings);
        return $user;
    }

    public function consultantReviewsOnly($id)
    {
        $ratings = Rating::where('consultant_id', $id)->orderBy('id', 'desc')
            ->paginate($this->pagination);
        return $ratings;
    }
    public function consultantTimeslot($id)
    {
        $user = User::findOrFail($id);
        $ratings = $user->ratings()
            ->orderBy('id', 'desc')
            ->paginate($this->pagination);
        $user->setRelation('ratings', $ratings);
        return $user;
    }



    public function accountStatus($userId)
    {
        $user = User::find($userId);
        $user->status = ($user->status == 1) ? 0 : 1;
        $user->save();
        return $user;
    }

    public function delete($id)
    {
        $user = User::where('id', $id)
            ->where('type', 'consultant')
            ->firstOrFail();

        $user->delete();

        return true;
    }
}
