<?php

namespace App\Services;

use App\Models\Chart;
use App\Models\ChartSubmission;
use App\Services\Common\BaseService;

/**
 * Class JsonResponseService
 * @package App\Services
 */
class ChartService extends BaseService
{
    public function create($request)
    {
        $chart = new Chart();
        $chart->user_id = auth()->user()->id;
        $chart->name = $request->name;
        $chart->form_json = $request->form_json;
        $chart->save();
        return $chart;
    }

    public function update($request, $chart)
    {
        $chart->name = $request->name;
        $chart->form_json = $request->form_json;
        $chart->save();
        return $chart;
    }

    public function submitChart($request)
    {

        $chartSubmission = new ChartSubmission();
        $chartSubmission->user_id = auth()->user()->id;
        $chartSubmission->chart_id = $request->chart_id;
        $chartSubmission->form_json = $request->form_json;
        $chartSubmission->save();
        return $chartSubmission;
    }

    public function index($pagination)
    {

        $charts = Chart::when(request()->filled('status') && request('status') != 'all', function ($q) {
            $q->whereStatus(request('status'));
        })->when(request()->filled('search'), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request("search") . '%');
            });
        })->when(request()->filled('from'), function ($q) {
            $q->whereDate('created_at', '>=', request('from'));
        })->when(request()->filled('to'), function ($q) {
            $q->whereDate('created_at', '<=', request('to'));
        })->orderBy('id', 'desc') // Then order by id in descending order
            ->paginate($pagination);

        return $charts;
    }
}
