<?php

namespace App\Services;

use App\Models\Category;
use App\Services\Common\BaseService;

/**
 * Class JsonResponseService
 */
class CategoryService extends BaseService
{
    public function create($request)
    {
        $category = new Category;
        $category->name = $request->name;
        $category->status = $request->status;
        $category->save();

        return $category;
    }

    public function update($id, $request)
    {
        $category = Category::findOrFail($id);
        $category->name = $request->name;
        $category->status = $request->status;
        $category->save();

        return $category;
    }

    public function delete($id)
    {
        $category = Category::findOrFail($id);
        $category->delete();

        return 'Category deleted successfully';
    }

    public function status($id)
    {
        $category = Category::findOrFail($id);
        $category->status = ($category->status == 1) ? 0 : 1;
        $category->save();

        return $category;
    }

    public function list()
    {
        $categories = Category::when(request()->filled('status') && request('status') != 'all', function ($q) {
            $q->whereStatus(request('status'));
        })
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%'.request('search').'%');
                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))
                    ->whereDate('created_at', '<=', request('to'));
            })
            ->orderBy('id', 'desc') // Then order by id in descending order
            ->paginate($this->pagination);

        return $categories;
    }

    public function listActive()
    {
        $categories = Category::where('status', 1)->when(request()->filled('status') && request('status') != 'all', function ($q) {
            $q->whereStatus(request('status'));
        })
            ->when(request()->filled('search'), function ($q) {
                $q->where(function ($q) {
                    $q->where('name', 'like', '%'.request('search').'%');
                });
            })
            ->when(request()->filled('from'), function ($q) {
                $q->whereDate('created_at', '>=', request('from'))
                    ->whereDate('created_at', '<=', request('to'));
            })
            ->orderBy('id', 'desc') // Then order by id in descending order
            ->paginate($this->pagination);

        return $categories;
    }

    public function listActiveWithoutPagination()
    {
        $categories = Category::where('status', 1)
            ->orderBy('id', 'desc') // Then order by id in descending order
            ->get();

        return $categories;
    }
}
