<?php

namespace App\Observers;

use App\Models\Appointment;
use App\Models\User;
use App\Services\FirebaseService;
use Carbon\Carbon;

class AppointmentObserver
{
    /**
     * Handle the Appointment "retrieved" event.
     *
     * @param  \App\Models\Appointment  $appointment
     * @return void
     */
    public function retrieved(Appointment $appointment)
    {
        // $timeslotDateTime = Carbon::parse("{$appointment->timeslot->date} {$appointment->timeslot->time}");
        $timeslotDateTime = Carbon::parse("{$appointment->timeslot->date} {$appointment->timeslot->time}")->startOfMinute();
        if (Carbon::now()->gte($timeslotDateTime) && $appointment->status == 'upcoming') {
            $consultant = User::where('id', $appointment->consultant_id)->first();
            $title = "Your appointment with " . $consultant->first_name . " " . $consultant->last_name . " has started!";
            $body = "User ID: " . $consultant->id;
            $data = [
                "user" => $consultant,  // Optionally, you can pass just the ID or a limited set of user info
                "title" => $title,
                "body" => $body,
            ];
            $user = User::where('id', $appointment->user_id)->first();
            sendNotification($title, $body, $data, $consultant->id, $user);
            $token = $user->device_token;
            if ($token && $token != "undefined") {
                $firebaseService = new FirebaseService();
                $firebaseService->sendNotification($token, "Appointment Started", $title);
            }
            $appointment->status = 'inprogress'; // Or whatever status is required
            $appointment->save();
        }
    }
}
