<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendConsultantCredentials extends Notification
{
    use Queueable;

    protected $consultant;
    protected $password;

    /**
     * Create a new notification instance.
     *
     * @param $consultant
     * @param $password
     * @return void
     */
    public function __construct($consultant, $password)
    {
        $this->consultant = $consultant;
        $this->password = $password;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Welcome to Our Platform')
            ->line('Dear ' . $this->consultant->first_name . ' ' . $this->consultant->last_name)
            ->line('Congratulations! Your account has been successfully created as a consultant on our platform.')
            ->line('Here are your login credentials:')
            ->line('Email: ' . $this->consultant->email)
            ->line('Password: ' . $this->password)
            ->line('Please keep your login credentials safe. You can change your password later from the account settings.')
            ->line('If you have any questions, feel free to reach out to our support team.')
            ->line('Thank you for being a part of our community!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            // You can add other fields to represent the notification in array form if needed
        ];
    }
}
