<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TimeSlot extends Model
{
    use HasFactory;
    protected $fillable = ['consultant_id', 'date', 'time', 'status'];
    public const BOOKED = 'booked';
    public const AVAILABLE = 'available';

    // Relationship to User model
    public function consultant()
    {
        return $this->belongsTo(User::class, 'consultant_id');
    }
}
