<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceCategory extends Model
{
    use HasFactory;
    public const IMAGES_DIRECTORY = 'serviceCategory';
    protected $with = ['image'];
    public function image()
    {
        return $this->morphOne(Image::class, 'imageable');
    }
    public function services()
    {
        return $this->hasMany(Service::class)
            ->orderBy('index')
            ->orderBy('id', 'desc');
    }


    public function limitedServices()
    {
        return $this->hasMany(Service::class)->limit(4);
    }
}
