<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Service extends Model
{
    use HasFactory;
    public const IMAGES_DIRECTORY = 'service';
    protected $with = ['serviceCategory'];
    public function images()
    {
        return $this->morphMany(Image::class, 'imageable');
    }

    public function serviceCategory()
    {
        return $this->belongsTo(ServiceCategory::class);
    }
    public function consultants()
    {
        return $this->belongsToMany(User::class, 'service_consultants', 'service_id', 'user_id')
            ->withTimestamps(); // Optionally include timestamps if they are stored in the pivot table
    }

}
