<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Feedback extends Model
{
    use HasFactory, Notifiable;

    protected $table = 'feedbacks';

    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'subject',
        'message',
        'type',
        'interested_in',
        'botox_party',
    ];

    protected $casts = [
        'interested_in' => 'array',
    ];

    public const TYPE_USER = 'user';

    public const TYPE_GUEST = 'guest';

    public const TYPE_CONSULTANT = 'consultant';
}
