<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConsultantInventory extends Model
{
    use HasFactory;
    protected $with = ['subCategory'];
    protected $fillable = [
        'user_id',
        'quantity',
        'category_id',
        'sub_category_id',
        'appointment_id',
    ];

    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'sub_category_id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


}
