<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'name',
        'image',
        'status'
    ];
    public const PRIVATE = 'private';
    public const GROUP = 'group';

    // Relationship
    public function messages()
    {
        return $this->hasMany(ChatMessage::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'chat_users');
    }

    // Accessors
    public function getImageAttribute($value)
    {
        return $value ? asset(\HelperConstants::CHAT_IMAGE_DIRECTORY . $value) : null;
    }
}
