<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Observers\AppointmentObserver;
class Appointment extends Model
{
    use HasFactory;

    protected $with = ['timeslot'];
    public const UPCOMING = 'upcoming';
    public const INPROGRESS = 'inprogress';
    public const PAST = 'past';
    public const FILES_DIRECTORY = 'images/appointment/documents/';

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function consultant()
    {
        return $this->belongsTo(User::class, 'consultant_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function timeslot()
    {
        return $this->belongsTo(TimeSlot::class, 'time_slot_id');
    }

    protected static function boot()
    {
        parent::boot();

        // Register the AppointmentObserver
        static::observe(AppointmentObserver::class);
    }

    public function documents()
    {
        return $this->morphMany(Image::class, 'imageable');
    }
    public function inventories()
    {
        return $this->hasMany(ConsultantInventory::class);
    }

}

