<?php
namespace App\Http\Resources\User;

use App\Http\Resources\Rating\RatingResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserWithRatingDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $ratings = $this->ratings;

        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'dial_code' => $this->dial_code,
            'country_code' => $this->country_code,
            'image_url' => $this->image_url,
            'cover_photo_url' => $this->cover_photo_url,
            'status' => $this->status,
            'type' => $this->type,
            'total_reviews' => $ratings->count(),
            'average_rating' => round($ratings->avg('rating'), 1),
            'rating_1' => $ratings->where('rating', 1)->count(),
            'rating_2' => $ratings->where('rating', 2)->count(),
            'rating_3' => $ratings->where('rating', 3)->count(),
            'rating_4' => $ratings->where('rating', 4)->count(),
            'rating_5' => $ratings->where('rating', 5)->count(),
            'updated_at' => $this->updated_at,
        ];
    }
}
