<?php
namespace App\Http\Resources\User;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\Plan\PlanResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserSubscriptionResource extends JsonResource
{
    protected function addExpiryDate($timestamp, $type)
    {
        $expiry = "";
        if ($type == 'week') {
            $expiry = Carbon::parse($timestamp)->addWeek();
        }
        if ($type == 'month') {
            $expiry = Carbon::parse($timestamp)->addMonth();
        }
        if ($type == 'year') {
            $expiry = Carbon::parse($timestamp)->addYear();
        }
        return $expiry;
    }

    protected function getStatus($timestamp, $type)
    {
        // Get the expiry date based on the plan's interval
        $expiryDate = $this->addExpiryDate($timestamp, $type);

        // Check if the expiry date has passed
        if ($expiryDate->isPast()) {
            return 'expired'; // Status is expired if the expiry date has passed
        }

        return 'active'; // Status is active if the expiry date is in the future
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'auto_renew' => $this->auto_renew,
            'ends_at' => $this->addExpiryDate($this->created_at, $this->plan->interval), // expiry date
            'status' => $this->getStatus($this->created_at, $this->plan->interval), // active or expired
            'created_at' => $this->created_at,
            'user' => new UserListingResource($this->user),
            'plan' => new PlanResource($this->plan),
        ];
    }
}
