<?php

namespace App\Http\Resources\User;

use App\Http\Resources\ImageResource;
use App\Http\Resources\Rating\RatingResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ConsultantWithRatingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'dial_code' => $this->dial_code,
            'country_code' => $this->country_code,
            'image_url' => $this->image_url,
            'cover_photo_url' => $this->cover_photo_url,
            'status' => $this->status,
            'type' => $this->type,
            'personal_details' => $this->personal_details,
            'licence_no' => $this->licence_no,
            'license_expiration' => $this->license_expiration,
            'created_at' => $this->created_at,
            'license_images' => ImageResource::collection($this->licenseImages),
            'attachments' => ImageResource::collection($this->attachments),
            'ratings' => RatingResource::collection($this->ratings),
            'average_rating' => round($this->ratings->avg('rating'), 1),
            'rating_1' => $this->ratings->where('rating', 1)->count(),
            'rating_2' => $this->ratings->where('rating', 2)->count(),
            'rating_3' => $this->ratings->where('rating', 3)->count(),
            'rating_4' => $this->ratings->where('rating', 4)->count(),
            'rating_5' => $this->ratings->where('rating', 5)->count(),
        ];
    }
}
