<?php

namespace App\Http\Resources\User;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ConsultantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'full_name' => $this->full_name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'dial_code' => $this->dial_code,
            'country_code' => $this->country_code,
            'image_url' => $this->image_url,
            'cover_photo_url' => $this->cover_photo_url,
            'type' => $this->type,
            'status' => $this->status,
            'personal_details' => $this->personal_details,
            'licence_no' => $this->licence_no,
            'license_expiration' => $this->license_expiration,
            'created_at' => $this->created_at,
            'license_images' => ImageResource::collection($this->licenseImages),
            'attachments' => ImageResource::collection($this->attachments)
        ];
    }
}
