<?php

namespace App\Http\Resources\ServiceCategory;

use App\Http\Resources\ImageResource;
use App\Http\Resources\Service\ServiceWithoutCategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceCategoryWithServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $services = $this->services->sortBy('index')->values();

        return [
            'id' => $this->id,
            'title' => $this->title,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'image' => new ImageResource($this->image),
            'services' => ServiceWithoutCategoryResource::collection($services),
        ];
    }
}
