<?php

namespace App\Http\Resources\Service;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceWithoutCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "title" => $this->title,
            "description" => $this->description,
            "charges" => $this->charges,
            "status" => $this->status,
            "created_at" => $this->created_at,
            "total_consultants" => $this->consultants->count(),
            "images" => ImageResource::collection($this->images),
        ];
    }
}
