<?php

namespace App\Http\Resources\Service;

use App\Http\Resources\ImageResource;
use App\Http\Resources\ServiceCategory\ServiceCategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'charges' => $this->charges,
            'index' => $this->index,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'images' => ImageResource::collection($this->images),
            'service_category' => new ServiceCategoryResource($this->serviceCategory),
            'total_consultants' => $this->consultants->count(),
        ];
    }
}
