<?php

namespace App\Http\Resources\Service;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\ServiceCategory\ServiceCategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "title" => $this->title,
            "description" => $this->description,
            "charges" => $this->charges,
            "status" => $this->status,
            "created_at" => $this->created_at,
            "service_category" => new ServiceCategoryResource($this->serviceCategory),
            "images" => ImageResource::collection($this->images),
            "consultants" => UserListingResource::collection($this->consultants),
        ];
    }
}
