<?php

namespace App\Http\Resources;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\Appointment\AppointmentDetailsResource;
use App\Http\Resources\Appointment\AppointmentListingResource;
use App\Http\Resources\Post\PostResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'reason' => $this->reason,
            'status' => $this->status,
            'type' => $this->type,
            'reportable_type' => $this->reportable_type,
            'reportable' => $this->getReportableResource(),
            'user' => new UserListingResource($this->user),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
    /**
     * Get the reportable resource.
     *
     * @return JsonResource
     */
    protected function getReportableResource(): JsonResource
    {
        $reportableType = $this->reportable_type;
        $resourceClass = $this->getResourceClassForReportableType($reportableType);
        return new $resourceClass($this->reportable);
    }
    /**
     * Get the resource class for the given reportable type.
     *
     * @param  string  $reportableType
     * @return string
     */
    protected function getResourceClassForReportableType(string $reportableType): string
    {
        return match ($reportableType) {
            'App\\Models\\Appointment' => AppointmentDetailsResource::class,
            'App\\Models\\User' => UserListingResource::class,
            default => DefaultResource::class,
        };
    }
}
