<?php

namespace App\Http\Resources\Rating;

use App\Http\Resources\Admin\UserListingResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RatingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "rating" => $this->rating,
            "review" => $this->review,
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
            'user' => new UserListingResource($this->user)
        ];
    }
}
