<?php

namespace App\Http\Resources\Question;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PreferenceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Get the actual answer options from the relationship
        // $answers = $this->whenLoaded('questionOptions', function () {
        //     return $this->questionOptions->map(function ($option) {
        //         return [
        //             'id' => $option->id,
        //             'text' => $option->option_text,  // Assuming 'text' is the field with the answer text in QuestionOption
        //         ];
        //     });
        // });

        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'question' => $this->question,
            'answer' => json_decode($this->answer),
        ];
    }
}
