<?php

namespace App\Http\Resources;

use App\Http\Resources\Product\ProductSizeResource;
use App\Http\Resources\Rating\RatingResource;
use App\Http\Resources\Size\SizeResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'price' => $this->price,
            'quantity' => $this->quantity,
            'description' => $this->description,
            'sku' => $this->sku,
            'discounted_price' => $this->discounted_price,
            'status' => $this->status,
            'image' => $this->image,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'is_in_wishlist' => $this->isInWishlist ? true : false,
            'wishlist' => $this->isInWishlist,
            'product_sizes' => SizeResource::collection($this->productSizes),
            'images' => ImageResource::collection($this->images),
            'category' => new CategoryResource($this->category),
            'ratings' => RatingResource::collection($this->ratings),
            'average_rating' => round($this->ratings->avg('rating'), 1),
            'rating_1' => $this->ratings->where('rating', 1)->count(),
            'rating_2' => $this->ratings->where('rating', 2)->count(),
            'rating_3' => $this->ratings->where('rating', 3)->count(),
            'rating_4' => $this->ratings->where('rating', 4)->count(),
            'rating_5' => $this->ratings->where('rating', 5)->count(),
        ];
    }
}
