<?php

namespace App\Http\Resources\PaymentLog;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\Appointment\AppointmentDetailsResource;
use App\Http\Resources\DefaultResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentLogResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'stripe_checkout_id' => $this->stripe_checkout_id,
            'currency' => $this->currency,
            'amount' => $this->amount,
            'paymentable_type' => $this->paymentable_type,
            'paymentable' => $this->getPaymentableResource(),
            'user' => new UserListingResource($this->user),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }

    /**
     * Get the reportable resource.
     *
     * @return JsonResource
     */
    protected function getPaymentableResource(): JsonResource
    {
        $paymentableType = $this->paymentable_type;
        $resourceClass = $this->getResourceClassForPaymentableType($paymentableType);
        return new $resourceClass($this->paymentable);
    }
    /**
     * Get the resource class for the given reportable type.
     *
     * @param  string  $paymentableType
     * @return string
     */
    protected function getResourceClassForPaymentableType(string $paymentableType): string
    {
        return match ($paymentableType) {
            'App\\Models\\Appointment' => AppointmentDetailsResource::class,
            // You can add more cases here for other models, if needed
            default => DefaultResource::class, // Ensure DefaultResource is used for unexpected cases
        };
    }
}
