<?php

namespace App\Http\Resources\Order;

use App\Http\Resources\ProductResource;
use App\Http\Resources\Size\SizeResource;
use App\Http\Resources\StoreResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            "price" => $this->price,
            "quantity" => $this->quantity,
            'size' => new SizeResource($this->size),

            // "status" => $this->status,
            'product' => new ProductResource($this->product),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
