<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // dd($this->data['content']['title']);
        return [
            "id" => $this->id,
            "title" => $this->data['content']['title'],
            'message' => $this->data['content']['body'],
            'read_at' => $this->read_at,
            // "type" => $this->data['data']['type'],
            // "content_id" => $this->data['data']['content_id'],
            'updated_at' => $this->updated_at,
            "created_at" => $this->created_at,
        ];
    }
}
