<?php

namespace App\Http\Resources\Consultant;

use App\Http\Resources\Category\SubCategoryResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InventoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "quantity" => $this->quantity,
            "sub_category" => new SubCategoryResource($this->subCategory),
        ];
    }
}
