<?php

namespace App\Http\Resources\Chat;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChatMessagesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'user_name' => $this->user->name,
            'chat_id' => $this->chat_id,
            'message' => $this->message,
            'read_at' => $this->read_at,
            'date' => $this->created_at->format('Y-m-d'),
            'time' => $this->created_at->format('H:i')
        ];// 'readable_time' => $this->created_at->diffForHumans(),];
    }
}
