<?php

namespace App\Http\Resources;

use App\Http\Resources\Admin\UserListingResource;
use Google\Api\FieldInfo\Format;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChartResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            "form_json" => $this->form_json,
            "created_at" => $this->created_at->format('d/m/Y'),
            "updated_at" => $this->updated_at->format('d/m/Y'),
            "user" => $this->whenLoaded('user', function () {
                return new UserListingResource($this->user);
            })
        ];
    }
}
