<?php

namespace App\Http\Resources\Banner;

use App\Http\Resources\ImageResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BannerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'image' => new ImageResource($this->image),
            'expiry_date' => $this->expiry_date,
            'updated_at' => $this->updated_at,
            'created_at' => $this->created_at,
        ];
    }
}
